/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.common;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;

@Immutable
public abstract class AbstractGlobalConfiguration {
    public static final String DEFAULT_WORK_DIR = "work";
    private final LogOutput logOutput;
    private final Path sonarLintUserHome;
    private final Path workDir;

    public AbstractGlobalConfiguration(AbstractBuilder<?> builder) {
        this.sonarLintUserHome = ((AbstractBuilder)builder).sonarlintUserHome != null ? ((AbstractBuilder)builder).sonarlintUserHome : AbstractGlobalConfiguration.findHome();
        this.workDir = ((AbstractBuilder)builder).workDir != null ? ((AbstractBuilder)builder).workDir : this.sonarLintUserHome.resolve(DEFAULT_WORK_DIR);
        this.logOutput = ((AbstractBuilder)builder).logOutput;
    }

    public Path getSonarLintUserHome() {
        return this.sonarLintUserHome;
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    @CheckForNull
    public LogOutput getLogOutput() {
        return this.logOutput;
    }

    private static Path findHome() {
        String path = System.getenv("SONARLINT_USER_HOME");
        if (path == null) {
            path = System.getProperty("user.home") + File.separator + ".sonarlint";
        }
        return Paths.get(path, new String[0]);
    }

    public static class AbstractBuilder<G extends AbstractBuilder> {
        private LogOutput logOutput;
        private Path sonarlintUserHome;
        private Path workDir;

        public G setLogOutput(@Nullable LogOutput logOutput) {
            this.logOutput = logOutput;
            return (G)this;
        }

        public G setSonarLintUserHome(Path sonarlintUserHome) {
            this.sonarlintUserHome = sonarlintUserHome;
            return (G)this;
        }

        public G setWorkDir(Path workDir) {
            this.workDir = workDir;
            return (G)this;
        }
    }
}

